import numpy as np
from scipy import signal
from scipy import misc
from Tkinter import Tk
import tkFileDialog
import os
import glob

############ Import data and put it in 2D array ############
def open_2Darray(filename):
    f = open(filename, 'r') #read the file with results
    x = f.readlines()
    f.close()
    
    Z=[]
    
    for k in range(0,len(x)):
        y = np.asarray(x[k].split('\t')) #read the line k, split elements, gather elements in an array
        z = y.astype(np.float)
        Z.append(z)
    return Z
##########################################################


#ask user for folder

root = Tk()
#root.withdraw() #use to hide tkinter window

currdir = 'C:\Users\mangeol\Desktop\Donnees triees\Polarity proteins colocalization'
foldername = tkFileDialog.askdirectory(parent=root, initialdir=currdir, title='Please select the directory with images to analyze')
root.withdraw()
#foldername = 'C:\Users\mangeol\Desktop\Donnees triees\Polarity proteins colocalization\PATJ PALS1\TC7 14 days - planar\Extracted junctions for colocalization'

folders = []
for x in os.walk(foldername):
    folders.append(x[0])

#####

#### extract protein names from file called image_list
string_with_prot_name = open(foldername + '\\image_list.txt', 'r') 
text_for_protein_1 = string_with_prot_name.readline()
text_for_protein_2 = string_with_prot_name.readline()
text_for_protein_1 = text_for_protein_1[0:len(text_for_protein_1)-1] + '_'
text_for_protein_2 = text_for_protein_2[0:len(text_for_protein_2)-1] + '_'

for j in range(1,len(folders)):
    i = 1
    protein_1 = []
    protein_2 = []

    while os.path.isfile(folders[j] + '\\' + text_for_protein_1 + str(i) + '.txt'): #read files of index 'i'
        f = open(folders[j] + '\\' + text_for_protein_1 + str(i) + '.txt', 'r') #read the file with results
        x = f.readlines()
        f.close()
        f = open(folders[j] + '\\' + text_for_protein_2 + str(i) + '.txt', 'r') #read the file with results
        x2 = f.readlines()
        f.close()
        for k in range(0,len(x)):
            y = np.asarray(x[k].split('\t')) #read the line k, split elements, gather elements in an array
            z = y.astype(np.float)
            protein_1.append(z)
            y = np.asarray(x2[k].split('\t')) #read the line k, split elements, gather elements in an array
            z = y.astype(np.float)
            protein_2.append(z)
        i += i

    #Calculation of correlation images; normalization is used to follow Wu et al. BiophysJ 2010 definitions of crosscorrelation
    # save image after each calculation is finished
    corr = signal.correlate2d(protein_1, protein_2, boundary='symm', mode='same')/(np.mean(protein_1)*np.mean(protein_2))
    np.savetxt(foldername + '\\' + text_for_protein_1 + text_for_protein_2 + str(j) +"cross-corr.txt", corr)
    corr_protein_1 = signal.correlate2d(protein_1, protein_1, boundary='symm', mode='same')/(np.mean(protein_1)**2)
    np.savetxt(foldername + '\\' + text_for_protein_1 + str(j) +"auto-corr.txt", corr_protein_1)
    corr_protein_2 = signal.correlate2d(protein_2, protein_2, boundary='symm', mode='same')/(np.mean(protein_2)**2)
    np.savetxt(foldername + '\\' + text_for_protein_2 + str(j) +"auto-corr.txt", corr_protein_2)
